(()=>{"use strict";var e={142:e=>{e.exports=require("next/dist/compiled/content-type")},238:e=>{e.exports=require("next/dist/compiled/raw-body")},788:e=>{e.exports=require("next/dist/compiled/zod")},5:e=>{e.exports=require("node:crypto")},685:function(e,t,s){var o=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:true});t.StreamableHTTPServerTransport=void 0;const a=s(383);const i=o(s(238));const n=o(s(142));const r=s(5);const c="4mb";class StreamableHTTPServerTransport{constructor(e){var t,s;this._started=false;this._streamMapping=new Map;this._requestToStreamMapping=new Map;this._requestResponseMap=new Map;this._initialized=false;this._enableJsonResponse=false;this._standaloneSseStreamId="_GET_stream";this.sessionIdGenerator=e.sessionIdGenerator;this._enableJsonResponse=(t=e.enableJsonResponse)!==null&&t!==void 0?t:false;this._eventStore=e.eventStore;this._onsessioninitialized=e.onsessioninitialized;this._onsessionclosed=e.onsessionclosed;this._allowedHosts=e.allowedHosts;this._allowedOrigins=e.allowedOrigins;this._enableDnsRebindingProtection=(s=e.enableDnsRebindingProtection)!==null&&s!==void 0?s:false}async start(){if(this._started){throw new Error("Transport already started")}this._started=true}validateRequestHeaders(e){if(!this._enableDnsRebindingProtection){return undefined}if(this._allowedHosts&&this._allowedHosts.length>0){const t=e.headers.host;if(!t||!this._allowedHosts.includes(t)){return`Invalid Host header: ${t}`}}if(this._allowedOrigins&&this._allowedOrigins.length>0){const t=e.headers.origin;if(!t||!this._allowedOrigins.includes(t)){return`Invalid Origin header: ${t}`}}return undefined}async handleRequest(e,t,s){var o;const a=this.validateRequestHeaders(e);if(a){t.writeHead(403).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:a},id:null}));(o=this.onerror)===null||o===void 0?void 0:o.call(this,new Error(a));return}if(e.method==="POST"){await this.handlePostRequest(e,t,s)}else if(e.method==="GET"){await this.handleGetRequest(e,t)}else if(e.method==="DELETE"){await this.handleDeleteRequest(e,t)}else{await this.handleUnsupportedRequest(t)}}async handleGetRequest(e,t){const s=e.headers.accept;if(!(s===null||s===void 0?void 0:s.includes("text/event-stream"))){t.writeHead(406).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:"Not Acceptable: Client must accept text/event-stream"},id:null}));return}if(!this.validateSession(e,t)){return}if(!this.validateProtocolVersion(e,t)){return}if(this._eventStore){const s=e.headers["last-event-id"];if(s){await this.replayEvents(s,t);return}}const o={"Content-Type":"text/event-stream","Cache-Control":"no-cache, no-transform",Connection:"keep-alive"};if(this.sessionId!==undefined){o["mcp-session-id"]=this.sessionId}if(this._streamMapping.get(this._standaloneSseStreamId)!==undefined){t.writeHead(409).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:"Conflict: Only one SSE stream is allowed per session"},id:null}));return}t.writeHead(200,o).flushHeaders();this._streamMapping.set(this._standaloneSseStreamId,t);t.on("close",(()=>{this._streamMapping.delete(this._standaloneSseStreamId)}));t.on("error",(e=>{var t;(t=this.onerror)===null||t===void 0?void 0:t.call(this,e)}))}async replayEvents(e,t){var s,o;if(!this._eventStore){return}try{const o={"Content-Type":"text/event-stream","Cache-Control":"no-cache, no-transform",Connection:"keep-alive"};if(this.sessionId!==undefined){o["mcp-session-id"]=this.sessionId}t.writeHead(200,o).flushHeaders();const a=await((s=this._eventStore)===null||s===void 0?void 0:s.replayEventsAfter(e,{send:async(e,s)=>{var o;if(!this.writeSSEEvent(t,s,e)){(o=this.onerror)===null||o===void 0?void 0:o.call(this,new Error("Failed replay events"));t.end()}}}));this._streamMapping.set(a,t);t.on("error",(e=>{var t;(t=this.onerror)===null||t===void 0?void 0:t.call(this,e)}))}catch(e){(o=this.onerror)===null||o===void 0?void 0:o.call(this,e)}}writeSSEEvent(e,t,s){let o=`event: message\n`;if(s){o+=`id: ${s}\n`}o+=`data: ${JSON.stringify(t)}\n\n`;return e.write(o)}async handleUnsupportedRequest(e){e.writeHead(405,{Allow:"GET, POST, DELETE"}).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:"Method not allowed."},id:null}))}async handlePostRequest(e,t,s){var o,l,h,m,u;try{const u=e.headers.accept;if(!(u===null||u===void 0?void 0:u.includes("application/json"))||!u.includes("text/event-stream")){t.writeHead(406).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:"Not Acceptable: Client must accept both application/json and text/event-stream"},id:null}));return}const d=e.headers["content-type"];if(!d||!d.includes("application/json")){t.writeHead(415).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:"Unsupported Media Type: Content-Type must be application/json"},id:null}));return}const S=e.auth;const p={headers:e.headers};let z;if(s!==undefined){z=s}else{const t=n.default.parse(d);const s=await(0,i.default)(e,{limit:c,encoding:(o=t.parameters.charset)!==null&&o!==void 0?o:"utf-8"});z=JSON.parse(s.toString())}let R;if(Array.isArray(z)){R=z.map((e=>a.JSONRPCMessageSchema.parse(e)))}else{R=[a.JSONRPCMessageSchema.parse(z)]}const g=R.some(a.isInitializeRequest);if(g){if(this._initialized&&this.sessionId!==undefined){t.writeHead(400).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32600,message:"Invalid Request: Server already initialized"},id:null}));return}if(R.length>1){t.writeHead(400).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32600,message:"Invalid Request: Only one initialization request is allowed"},id:null}));return}this.sessionId=(l=this.sessionIdGenerator)===null||l===void 0?void 0:l.call(this);this._initialized=true;if(this.sessionId&&this._onsessioninitialized){await Promise.resolve(this._onsessioninitialized(this.sessionId))}}if(!g){if(!this.validateSession(e,t)){return}if(!this.validateProtocolVersion(e,t)){return}}const f=R.some(a.isJSONRPCRequest);if(!f){t.writeHead(202).end();for(const e of R){(h=this.onmessage)===null||h===void 0?void 0:h.call(this,e,{authInfo:S,requestInfo:p})}}else if(f){const e=(0,r.randomUUID)();if(!this._enableJsonResponse){const e={"Content-Type":"text/event-stream","Cache-Control":"no-cache",Connection:"keep-alive"};if(this.sessionId!==undefined){e["mcp-session-id"]=this.sessionId}t.writeHead(200,e)}for(const s of R){if((0,a.isJSONRPCRequest)(s)){this._streamMapping.set(e,t);this._requestToStreamMapping.set(s.id,e)}}t.on("close",(()=>{this._streamMapping.delete(e)}));t.on("error",(e=>{var t;(t=this.onerror)===null||t===void 0?void 0:t.call(this,e)}));for(const e of R){(m=this.onmessage)===null||m===void 0?void 0:m.call(this,e,{authInfo:S,requestInfo:p})}}}catch(e){t.writeHead(400).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32700,message:"Parse error",data:String(e)},id:null}));(u=this.onerror)===null||u===void 0?void 0:u.call(this,e)}}async handleDeleteRequest(e,t){var s;if(!this.validateSession(e,t)){return}if(!this.validateProtocolVersion(e,t)){return}await Promise.resolve((s=this._onsessionclosed)===null||s===void 0?void 0:s.call(this,this.sessionId));await this.close();t.writeHead(200).end()}validateSession(e,t){if(this.sessionIdGenerator===undefined){return true}if(!this._initialized){t.writeHead(400).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:"Bad Request: Server not initialized"},id:null}));return false}const s=e.headers["mcp-session-id"];if(!s){t.writeHead(400).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:"Bad Request: Mcp-Session-Id header is required"},id:null}));return false}else if(Array.isArray(s)){t.writeHead(400).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:"Bad Request: Mcp-Session-Id header must be a single value"},id:null}));return false}else if(s!==this.sessionId){t.writeHead(404).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32001,message:"Session not found"},id:null}));return false}return true}validateProtocolVersion(e,t){var s;let o=(s=e.headers["mcp-protocol-version"])!==null&&s!==void 0?s:a.DEFAULT_NEGOTIATED_PROTOCOL_VERSION;if(Array.isArray(o)){o=o[o.length-1]}if(!a.SUPPORTED_PROTOCOL_VERSIONS.includes(o)){t.writeHead(400).end(JSON.stringify({jsonrpc:"2.0",error:{code:-32e3,message:`Bad Request: Unsupported protocol version (supported versions: ${a.SUPPORTED_PROTOCOL_VERSIONS.join(", ")})`},id:null}));return false}return true}async close(){var e;this._streamMapping.forEach((e=>{e.end()}));this._streamMapping.clear();this._requestResponseMap.clear();(e=this.onclose)===null||e===void 0?void 0:e.call(this)}async send(e,t){let s=t===null||t===void 0?void 0:t.relatedRequestId;if((0,a.isJSONRPCResponse)(e)||(0,a.isJSONRPCError)(e)){s=e.id}if(s===undefined){if((0,a.isJSONRPCResponse)(e)||(0,a.isJSONRPCError)(e)){throw new Error("Cannot send a response on a standalone SSE stream unless resuming a previous client request")}const t=this._streamMapping.get(this._standaloneSseStreamId);if(t===undefined){return}let s;if(this._eventStore){s=await this._eventStore.storeEvent(this._standaloneSseStreamId,e)}this.writeSSEEvent(t,e,s);return}const o=this._requestToStreamMapping.get(s);const i=this._streamMapping.get(o);if(!o){throw new Error(`No connection established for request ID: ${String(s)}`)}if(!this._enableJsonResponse){let t;if(this._eventStore){t=await this._eventStore.storeEvent(o,e)}if(i){this.writeSSEEvent(i,e,t)}}if((0,a.isJSONRPCResponse)(e)||(0,a.isJSONRPCError)(e)){this._requestResponseMap.set(s,e);const t=Array.from(this._requestToStreamMapping.entries()).filter((([e,t])=>this._streamMapping.get(t)===i)).map((([e])=>e));const o=t.every((e=>this._requestResponseMap.has(e)));if(o){if(!i){throw new Error(`No connection established for request ID: ${String(s)}`)}if(this._enableJsonResponse){const e={"Content-Type":"application/json"};if(this.sessionId!==undefined){e["mcp-session-id"]=this.sessionId}const s=t.map((e=>this._requestResponseMap.get(e)));i.writeHead(200,e);if(s.length===1){i.end(JSON.stringify(s[0]))}else{i.end(JSON.stringify(s))}}else{i.end()}for(const e of t){this._requestResponseMap.delete(e);this._requestToStreamMapping.delete(e)}}}}}t.StreamableHTTPServerTransport=StreamableHTTPServerTransport},383:(e,t,s)=>{Object.defineProperty(t,"__esModule",{value:true});t.SubscribeRequestSchema=t.ResourceListChangedNotificationSchema=t.ReadResourceResultSchema=t.ReadResourceRequestSchema=t.ListResourceTemplatesResultSchema=t.ListResourceTemplatesRequestSchema=t.ListResourcesResultSchema=t.ListResourcesRequestSchema=t.ResourceTemplateSchema=t.ResourceSchema=t.BlobResourceContentsSchema=t.TextResourceContentsSchema=t.ResourceContentsSchema=t.PaginatedResultSchema=t.PaginatedRequestSchema=t.ProgressNotificationSchema=t.ProgressSchema=t.PingRequestSchema=t.isInitializedNotification=t.InitializedNotificationSchema=t.InitializeResultSchema=t.ServerCapabilitiesSchema=t.isInitializeRequest=t.InitializeRequestSchema=t.ClientCapabilitiesSchema=t.ImplementationSchema=t.BaseMetadataSchema=t.IconSchema=t.CancelledNotificationSchema=t.EmptyResultSchema=t.JSONRPCMessageSchema=t.isJSONRPCError=t.JSONRPCErrorSchema=t.ErrorCode=t.isJSONRPCResponse=t.JSONRPCResponseSchema=t.isJSONRPCNotification=t.JSONRPCNotificationSchema=t.isJSONRPCRequest=t.JSONRPCRequestSchema=t.RequestIdSchema=t.ResultSchema=t.NotificationSchema=t.RequestSchema=t.CursorSchema=t.ProgressTokenSchema=t.JSONRPC_VERSION=t.SUPPORTED_PROTOCOL_VERSIONS=t.DEFAULT_NEGOTIATED_PROTOCOL_VERSION=t.LATEST_PROTOCOL_VERSION=void 0;t.ClientNotificationSchema=t.ClientRequestSchema=t.RootsListChangedNotificationSchema=t.ListRootsResultSchema=t.ListRootsRequestSchema=t.RootSchema=t.CompleteResultSchema=t.CompleteRequestSchema=t.PromptReferenceSchema=t.ResourceReferenceSchema=t.ResourceTemplateReferenceSchema=t.ElicitResultSchema=t.ElicitRequestSchema=t.PrimitiveSchemaDefinitionSchema=t.EnumSchemaSchema=t.NumberSchemaSchema=t.StringSchemaSchema=t.BooleanSchemaSchema=t.CreateMessageResultSchema=t.CreateMessageRequestSchema=t.SamplingMessageSchema=t.ModelPreferencesSchema=t.ModelHintSchema=t.LoggingMessageNotificationSchema=t.SetLevelRequestSchema=t.LoggingLevelSchema=t.ToolListChangedNotificationSchema=t.CallToolRequestSchema=t.CompatibilityCallToolResultSchema=t.CallToolResultSchema=t.ListToolsResultSchema=t.ListToolsRequestSchema=t.ToolSchema=t.ToolAnnotationsSchema=t.PromptListChangedNotificationSchema=t.GetPromptResultSchema=t.PromptMessageSchema=t.ContentBlockSchema=t.ResourceLinkSchema=t.EmbeddedResourceSchema=t.AudioContentSchema=t.ImageContentSchema=t.TextContentSchema=t.GetPromptRequestSchema=t.ListPromptsResultSchema=t.ListPromptsRequestSchema=t.PromptSchema=t.PromptArgumentSchema=t.ResourceUpdatedNotificationSchema=t.UnsubscribeRequestSchema=void 0;t.McpError=t.ServerResultSchema=t.ServerNotificationSchema=t.ServerRequestSchema=t.ClientResultSchema=void 0;const o=s(788);t.LATEST_PROTOCOL_VERSION="2025-06-18";t.DEFAULT_NEGOTIATED_PROTOCOL_VERSION="2025-03-26";t.SUPPORTED_PROTOCOL_VERSIONS=[t.LATEST_PROTOCOL_VERSION,"2025-03-26","2024-11-05","2024-10-07"];t.JSONRPC_VERSION="2.0";t.ProgressTokenSchema=o.z.union([o.z.string(),o.z.number().int()]);t.CursorSchema=o.z.string();const a=o.z.object({progressToken:o.z.optional(t.ProgressTokenSchema)}).passthrough();const i=o.z.object({_meta:o.z.optional(a)}).passthrough();t.RequestSchema=o.z.object({method:o.z.string(),params:o.z.optional(i)});const n=o.z.object({_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.NotificationSchema=o.z.object({method:o.z.string(),params:o.z.optional(n)});t.ResultSchema=o.z.object({_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.RequestIdSchema=o.z.union([o.z.string(),o.z.number().int()]);t.JSONRPCRequestSchema=o.z.object({jsonrpc:o.z.literal(t.JSONRPC_VERSION),id:t.RequestIdSchema}).merge(t.RequestSchema).strict();const isJSONRPCRequest=e=>t.JSONRPCRequestSchema.safeParse(e).success;t.isJSONRPCRequest=isJSONRPCRequest;t.JSONRPCNotificationSchema=o.z.object({jsonrpc:o.z.literal(t.JSONRPC_VERSION)}).merge(t.NotificationSchema).strict();const isJSONRPCNotification=e=>t.JSONRPCNotificationSchema.safeParse(e).success;t.isJSONRPCNotification=isJSONRPCNotification;t.JSONRPCResponseSchema=o.z.object({jsonrpc:o.z.literal(t.JSONRPC_VERSION),id:t.RequestIdSchema,result:t.ResultSchema}).strict();const isJSONRPCResponse=e=>t.JSONRPCResponseSchema.safeParse(e).success;t.isJSONRPCResponse=isJSONRPCResponse;var r;(function(e){e[e["ConnectionClosed"]=-32e3]="ConnectionClosed";e[e["RequestTimeout"]=-32001]="RequestTimeout";e[e["ParseError"]=-32700]="ParseError";e[e["InvalidRequest"]=-32600]="InvalidRequest";e[e["MethodNotFound"]=-32601]="MethodNotFound";e[e["InvalidParams"]=-32602]="InvalidParams";e[e["InternalError"]=-32603]="InternalError"})(r||(t.ErrorCode=r={}));t.JSONRPCErrorSchema=o.z.object({jsonrpc:o.z.literal(t.JSONRPC_VERSION),id:t.RequestIdSchema,error:o.z.object({code:o.z.number().int(),message:o.z.string(),data:o.z.optional(o.z.unknown())})}).strict();const isJSONRPCError=e=>t.JSONRPCErrorSchema.safeParse(e).success;t.isJSONRPCError=isJSONRPCError;t.JSONRPCMessageSchema=o.z.union([t.JSONRPCRequestSchema,t.JSONRPCNotificationSchema,t.JSONRPCResponseSchema,t.JSONRPCErrorSchema]);t.EmptyResultSchema=t.ResultSchema.strict();t.CancelledNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/cancelled"),params:n.extend({requestId:t.RequestIdSchema,reason:o.z.string().optional()})});t.IconSchema=o.z.object({src:o.z.string(),mimeType:o.z.optional(o.z.string()),sizes:o.z.optional(o.z.string())}).passthrough();t.BaseMetadataSchema=o.z.object({name:o.z.string(),title:o.z.optional(o.z.string())}).passthrough();t.ImplementationSchema=t.BaseMetadataSchema.extend({version:o.z.string(),websiteUrl:o.z.optional(o.z.string()),icons:o.z.optional(o.z.array(t.IconSchema))});t.ClientCapabilitiesSchema=o.z.object({experimental:o.z.optional(o.z.object({}).passthrough()),sampling:o.z.optional(o.z.object({}).passthrough()),elicitation:o.z.optional(o.z.object({}).passthrough()),roots:o.z.optional(o.z.object({listChanged:o.z.optional(o.z.boolean())}).passthrough())}).passthrough();t.InitializeRequestSchema=t.RequestSchema.extend({method:o.z.literal("initialize"),params:i.extend({protocolVersion:o.z.string(),capabilities:t.ClientCapabilitiesSchema,clientInfo:t.ImplementationSchema})});const isInitializeRequest=e=>t.InitializeRequestSchema.safeParse(e).success;t.isInitializeRequest=isInitializeRequest;t.ServerCapabilitiesSchema=o.z.object({experimental:o.z.optional(o.z.object({}).passthrough()),logging:o.z.optional(o.z.object({}).passthrough()),completions:o.z.optional(o.z.object({}).passthrough()),prompts:o.z.optional(o.z.object({listChanged:o.z.optional(o.z.boolean())}).passthrough()),resources:o.z.optional(o.z.object({subscribe:o.z.optional(o.z.boolean()),listChanged:o.z.optional(o.z.boolean())}).passthrough()),tools:o.z.optional(o.z.object({listChanged:o.z.optional(o.z.boolean())}).passthrough())}).passthrough();t.InitializeResultSchema=t.ResultSchema.extend({protocolVersion:o.z.string(),capabilities:t.ServerCapabilitiesSchema,serverInfo:t.ImplementationSchema,instructions:o.z.optional(o.z.string())});t.InitializedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/initialized")});const isInitializedNotification=e=>t.InitializedNotificationSchema.safeParse(e).success;t.isInitializedNotification=isInitializedNotification;t.PingRequestSchema=t.RequestSchema.extend({method:o.z.literal("ping")});t.ProgressSchema=o.z.object({progress:o.z.number(),total:o.z.optional(o.z.number()),message:o.z.optional(o.z.string())}).passthrough();t.ProgressNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/progress"),params:n.merge(t.ProgressSchema).extend({progressToken:t.ProgressTokenSchema})});t.PaginatedRequestSchema=t.RequestSchema.extend({params:i.extend({cursor:o.z.optional(t.CursorSchema)}).optional()});t.PaginatedResultSchema=t.ResultSchema.extend({nextCursor:o.z.optional(t.CursorSchema)});t.ResourceContentsSchema=o.z.object({uri:o.z.string(),mimeType:o.z.optional(o.z.string()),_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.TextResourceContentsSchema=t.ResourceContentsSchema.extend({text:o.z.string()});const c=o.z.string().refine((e=>{try{atob(e);return true}catch(e){return false}}),{message:"Invalid Base64 string"});t.BlobResourceContentsSchema=t.ResourceContentsSchema.extend({blob:c});t.ResourceSchema=t.BaseMetadataSchema.extend({uri:o.z.string(),description:o.z.optional(o.z.string()),mimeType:o.z.optional(o.z.string()),icons:o.z.optional(o.z.array(t.IconSchema)),_meta:o.z.optional(o.z.object({}).passthrough())});t.ResourceTemplateSchema=t.BaseMetadataSchema.extend({uriTemplate:o.z.string(),description:o.z.optional(o.z.string()),mimeType:o.z.optional(o.z.string()),_meta:o.z.optional(o.z.object({}).passthrough())});t.ListResourcesRequestSchema=t.PaginatedRequestSchema.extend({method:o.z.literal("resources/list")});t.ListResourcesResultSchema=t.PaginatedResultSchema.extend({resources:o.z.array(t.ResourceSchema)});t.ListResourceTemplatesRequestSchema=t.PaginatedRequestSchema.extend({method:o.z.literal("resources/templates/list")});t.ListResourceTemplatesResultSchema=t.PaginatedResultSchema.extend({resourceTemplates:o.z.array(t.ResourceTemplateSchema)});t.ReadResourceRequestSchema=t.RequestSchema.extend({method:o.z.literal("resources/read"),params:i.extend({uri:o.z.string()})});t.ReadResourceResultSchema=t.ResultSchema.extend({contents:o.z.array(o.z.union([t.TextResourceContentsSchema,t.BlobResourceContentsSchema]))});t.ResourceListChangedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/resources/list_changed")});t.SubscribeRequestSchema=t.RequestSchema.extend({method:o.z.literal("resources/subscribe"),params:i.extend({uri:o.z.string()})});t.UnsubscribeRequestSchema=t.RequestSchema.extend({method:o.z.literal("resources/unsubscribe"),params:i.extend({uri:o.z.string()})});t.ResourceUpdatedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/resources/updated"),params:n.extend({uri:o.z.string()})});t.PromptArgumentSchema=o.z.object({name:o.z.string(),description:o.z.optional(o.z.string()),required:o.z.optional(o.z.boolean())}).passthrough();t.PromptSchema=t.BaseMetadataSchema.extend({description:o.z.optional(o.z.string()),arguments:o.z.optional(o.z.array(t.PromptArgumentSchema)),icons:o.z.optional(o.z.array(t.IconSchema)),_meta:o.z.optional(o.z.object({}).passthrough())});t.ListPromptsRequestSchema=t.PaginatedRequestSchema.extend({method:o.z.literal("prompts/list")});t.ListPromptsResultSchema=t.PaginatedResultSchema.extend({prompts:o.z.array(t.PromptSchema)});t.GetPromptRequestSchema=t.RequestSchema.extend({method:o.z.literal("prompts/get"),params:i.extend({name:o.z.string(),arguments:o.z.optional(o.z.record(o.z.string()))})});t.TextContentSchema=o.z.object({type:o.z.literal("text"),text:o.z.string(),_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.ImageContentSchema=o.z.object({type:o.z.literal("image"),data:c,mimeType:o.z.string(),_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.AudioContentSchema=o.z.object({type:o.z.literal("audio"),data:c,mimeType:o.z.string(),_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.EmbeddedResourceSchema=o.z.object({type:o.z.literal("resource"),resource:o.z.union([t.TextResourceContentsSchema,t.BlobResourceContentsSchema]),_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.ResourceLinkSchema=t.ResourceSchema.extend({type:o.z.literal("resource_link")});t.ContentBlockSchema=o.z.union([t.TextContentSchema,t.ImageContentSchema,t.AudioContentSchema,t.ResourceLinkSchema,t.EmbeddedResourceSchema]);t.PromptMessageSchema=o.z.object({role:o.z.enum(["user","assistant"]),content:t.ContentBlockSchema}).passthrough();t.GetPromptResultSchema=t.ResultSchema.extend({description:o.z.optional(o.z.string()),messages:o.z.array(t.PromptMessageSchema)});t.PromptListChangedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/prompts/list_changed")});t.ToolAnnotationsSchema=o.z.object({title:o.z.optional(o.z.string()),readOnlyHint:o.z.optional(o.z.boolean()),destructiveHint:o.z.optional(o.z.boolean()),idempotentHint:o.z.optional(o.z.boolean()),openWorldHint:o.z.optional(o.z.boolean())}).passthrough();t.ToolSchema=t.BaseMetadataSchema.extend({description:o.z.optional(o.z.string()),inputSchema:o.z.object({type:o.z.literal("object"),properties:o.z.optional(o.z.object({}).passthrough()),required:o.z.optional(o.z.array(o.z.string()))}).passthrough(),outputSchema:o.z.optional(o.z.object({type:o.z.literal("object"),properties:o.z.optional(o.z.object({}).passthrough()),required:o.z.optional(o.z.array(o.z.string()))}).passthrough()),annotations:o.z.optional(t.ToolAnnotationsSchema),icons:o.z.optional(o.z.array(t.IconSchema)),_meta:o.z.optional(o.z.object({}).passthrough())});t.ListToolsRequestSchema=t.PaginatedRequestSchema.extend({method:o.z.literal("tools/list")});t.ListToolsResultSchema=t.PaginatedResultSchema.extend({tools:o.z.array(t.ToolSchema)});t.CallToolResultSchema=t.ResultSchema.extend({content:o.z.array(t.ContentBlockSchema).default([]),structuredContent:o.z.object({}).passthrough().optional(),isError:o.z.optional(o.z.boolean())});t.CompatibilityCallToolResultSchema=t.CallToolResultSchema.or(t.ResultSchema.extend({toolResult:o.z.unknown()}));t.CallToolRequestSchema=t.RequestSchema.extend({method:o.z.literal("tools/call"),params:i.extend({name:o.z.string(),arguments:o.z.optional(o.z.record(o.z.unknown()))})});t.ToolListChangedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/tools/list_changed")});t.LoggingLevelSchema=o.z.enum(["debug","info","notice","warning","error","critical","alert","emergency"]);t.SetLevelRequestSchema=t.RequestSchema.extend({method:o.z.literal("logging/setLevel"),params:i.extend({level:t.LoggingLevelSchema})});t.LoggingMessageNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/message"),params:n.extend({level:t.LoggingLevelSchema,logger:o.z.optional(o.z.string()),data:o.z.unknown()})});t.ModelHintSchema=o.z.object({name:o.z.string().optional()}).passthrough();t.ModelPreferencesSchema=o.z.object({hints:o.z.optional(o.z.array(t.ModelHintSchema)),costPriority:o.z.optional(o.z.number().min(0).max(1)),speedPriority:o.z.optional(o.z.number().min(0).max(1)),intelligencePriority:o.z.optional(o.z.number().min(0).max(1))}).passthrough();t.SamplingMessageSchema=o.z.object({role:o.z.enum(["user","assistant"]),content:o.z.union([t.TextContentSchema,t.ImageContentSchema,t.AudioContentSchema])}).passthrough();t.CreateMessageRequestSchema=t.RequestSchema.extend({method:o.z.literal("sampling/createMessage"),params:i.extend({messages:o.z.array(t.SamplingMessageSchema),systemPrompt:o.z.optional(o.z.string()),includeContext:o.z.optional(o.z.enum(["none","thisServer","allServers"])),temperature:o.z.optional(o.z.number()),maxTokens:o.z.number().int(),stopSequences:o.z.optional(o.z.array(o.z.string())),metadata:o.z.optional(o.z.object({}).passthrough()),modelPreferences:o.z.optional(t.ModelPreferencesSchema)})});t.CreateMessageResultSchema=t.ResultSchema.extend({model:o.z.string(),stopReason:o.z.optional(o.z.enum(["endTurn","stopSequence","maxTokens"]).or(o.z.string())),role:o.z.enum(["user","assistant"]),content:o.z.discriminatedUnion("type",[t.TextContentSchema,t.ImageContentSchema,t.AudioContentSchema])});t.BooleanSchemaSchema=o.z.object({type:o.z.literal("boolean"),title:o.z.optional(o.z.string()),description:o.z.optional(o.z.string()),default:o.z.optional(o.z.boolean())}).passthrough();t.StringSchemaSchema=o.z.object({type:o.z.literal("string"),title:o.z.optional(o.z.string()),description:o.z.optional(o.z.string()),minLength:o.z.optional(o.z.number()),maxLength:o.z.optional(o.z.number()),format:o.z.optional(o.z.enum(["email","uri","date","date-time"]))}).passthrough();t.NumberSchemaSchema=o.z.object({type:o.z.enum(["number","integer"]),title:o.z.optional(o.z.string()),description:o.z.optional(o.z.string()),minimum:o.z.optional(o.z.number()),maximum:o.z.optional(o.z.number())}).passthrough();t.EnumSchemaSchema=o.z.object({type:o.z.literal("string"),title:o.z.optional(o.z.string()),description:o.z.optional(o.z.string()),enum:o.z.array(o.z.string()),enumNames:o.z.optional(o.z.array(o.z.string()))}).passthrough();t.PrimitiveSchemaDefinitionSchema=o.z.union([t.BooleanSchemaSchema,t.StringSchemaSchema,t.NumberSchemaSchema,t.EnumSchemaSchema]);t.ElicitRequestSchema=t.RequestSchema.extend({method:o.z.literal("elicitation/create"),params:i.extend({message:o.z.string(),requestedSchema:o.z.object({type:o.z.literal("object"),properties:o.z.record(o.z.string(),t.PrimitiveSchemaDefinitionSchema),required:o.z.optional(o.z.array(o.z.string()))}).passthrough()})});t.ElicitResultSchema=t.ResultSchema.extend({action:o.z.enum(["accept","decline","cancel"]),content:o.z.optional(o.z.record(o.z.string(),o.z.unknown()))});t.ResourceTemplateReferenceSchema=o.z.object({type:o.z.literal("ref/resource"),uri:o.z.string()}).passthrough();t.ResourceReferenceSchema=t.ResourceTemplateReferenceSchema;t.PromptReferenceSchema=o.z.object({type:o.z.literal("ref/prompt"),name:o.z.string()}).passthrough();t.CompleteRequestSchema=t.RequestSchema.extend({method:o.z.literal("completion/complete"),params:i.extend({ref:o.z.union([t.PromptReferenceSchema,t.ResourceTemplateReferenceSchema]),argument:o.z.object({name:o.z.string(),value:o.z.string()}).passthrough(),context:o.z.optional(o.z.object({arguments:o.z.optional(o.z.record(o.z.string(),o.z.string()))}))})});t.CompleteResultSchema=t.ResultSchema.extend({completion:o.z.object({values:o.z.array(o.z.string()).max(100),total:o.z.optional(o.z.number().int()),hasMore:o.z.optional(o.z.boolean())}).passthrough()});t.RootSchema=o.z.object({uri:o.z.string().startsWith("file://"),name:o.z.optional(o.z.string()),_meta:o.z.optional(o.z.object({}).passthrough())}).passthrough();t.ListRootsRequestSchema=t.RequestSchema.extend({method:o.z.literal("roots/list")});t.ListRootsResultSchema=t.ResultSchema.extend({roots:o.z.array(t.RootSchema)});t.RootsListChangedNotificationSchema=t.NotificationSchema.extend({method:o.z.literal("notifications/roots/list_changed")});t.ClientRequestSchema=o.z.union([t.PingRequestSchema,t.InitializeRequestSchema,t.CompleteRequestSchema,t.SetLevelRequestSchema,t.GetPromptRequestSchema,t.ListPromptsRequestSchema,t.ListResourcesRequestSchema,t.ListResourceTemplatesRequestSchema,t.ReadResourceRequestSchema,t.SubscribeRequestSchema,t.UnsubscribeRequestSchema,t.CallToolRequestSchema,t.ListToolsRequestSchema]);t.ClientNotificationSchema=o.z.union([t.CancelledNotificationSchema,t.ProgressNotificationSchema,t.InitializedNotificationSchema,t.RootsListChangedNotificationSchema]);t.ClientResultSchema=o.z.union([t.EmptyResultSchema,t.CreateMessageResultSchema,t.ElicitResultSchema,t.ListRootsResultSchema]);t.ServerRequestSchema=o.z.union([t.PingRequestSchema,t.CreateMessageRequestSchema,t.ElicitRequestSchema,t.ListRootsRequestSchema]);t.ServerNotificationSchema=o.z.union([t.CancelledNotificationSchema,t.ProgressNotificationSchema,t.LoggingMessageNotificationSchema,t.ResourceUpdatedNotificationSchema,t.ResourceListChangedNotificationSchema,t.ToolListChangedNotificationSchema,t.PromptListChangedNotificationSchema]);t.ServerResultSchema=o.z.union([t.EmptyResultSchema,t.InitializeResultSchema,t.CompleteResultSchema,t.GetPromptResultSchema,t.ListPromptsResultSchema,t.ListResourcesResultSchema,t.ListResourceTemplatesResultSchema,t.ReadResourceResultSchema,t.CallToolResultSchema,t.ListToolsResultSchema]);class McpError extends Error{constructor(e,t,s){super(`MCP error ${e}: ${t}`);this.code=e;this.data=s;this.name="McpError"}}t.McpError=McpError}};var t={};function __nccwpck_require__(s){var o=t[s];if(o!==undefined){return o.exports}var a=t[s]={exports:{}};var i=true;try{e[s].call(a.exports,a,a.exports,__nccwpck_require__);i=false}finally{if(i)delete t[s]}return a.exports}if(typeof __nccwpck_require__!=="undefined")__nccwpck_require__.ab=__dirname+"/";var s=__nccwpck_require__(685);module.exports=s})();